package com.agilex.healthcare.directscheduling.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import com.agilex.healthcare.directscheduling.domain.FacilityMemberTeam;
import com.agilex.healthcare.directscheduling.domain.FacilityMember;

public class PatientResultSetRowMapperTeam implements PatientResultSetRowMapper {

	private static final int STA3N_COL = 1;
	private static final int TEAM_SID_COL = 2;
	private static final int TEAM_COL = 3;
	private static final int TEAM_PURPOSE_COL = 4;
	private static final int PROV_SID_COL = 5;
	private static final int STAFF_NAME_COL = 6;
	private static final int PROV_POS_COL = 7;
	private static final int PROV_STAND_POS_COL = 8;
	private static final int POSSIBLE_PRIM_COL = 9;

	@Override
	public FacilityMember mapRow(ResultSet rs, int rowNum) throws SQLException {

		FacilityMemberTeam facilityMemberTeam = new FacilityMemberTeam();

		facilityMemberTeam.setFacilityId(StringUtils.trimToEmpty(rs
				.getString(STA3N_COL)));
		facilityMemberTeam.setTeamSid(StringUtils.trimToEmpty(rs
				.getString(TEAM_SID_COL)));
		facilityMemberTeam.setTeamName(StringUtils.trimToEmpty(rs
				.getString(TEAM_COL)));
		facilityMemberTeam.setTeamPurpose(StringUtils.trimToEmpty(rs
				.getString(TEAM_PURPOSE_COL)));
		facilityMemberTeam.setProviderSid(StringUtils.trimToEmpty(rs
				.getString(PROV_SID_COL)));
		facilityMemberTeam.setStaffName(StringUtils.trimToEmpty(rs
				.getString(STAFF_NAME_COL)));
		facilityMemberTeam.setProviderPosition(StringUtils.trimToEmpty(rs
				.getString(PROV_POS_COL)));
		facilityMemberTeam.setProviderStandardPosition(StringUtils
				.trimToEmpty(rs.getString(PROV_STAND_POS_COL)));
		facilityMemberTeam.setPossiblePrimary(StringUtils.trimToEmpty(rs
				.getString(POSSIBLE_PRIM_COL)));

		return (facilityMemberTeam);
	}
}